using System;
using Server;
using Server.Items;

namespace Server.Mobiles
{
	//[CorpseName( "an ophidian corpse" )]
	public class IceOphidianMatriarch : OphidianMatriarch
	{
		public override WeaponAbility GetWeaponAbility()
		{
			switch (Utility.Random(3))
			{
				default:
					case 0: return WeaponAbility.DoubleStrike;
				case 1: return WeaponAbility.MortalStrike;
				case 2: return WeaponAbility.CrushingBlow;
			}
		}

		[Constructable]
		public IceOphidianMatriarch() : base()
		{
			Hue = 496;
			Name = "ophidianska matriarcha";
			AI = AIType.AI_Necromage;

			SetStr(505, 700);
			SetDex(202, 300);
			SetInt(502, 620);

			SetHits(1500, 2000);
			SetStam(305, 600);
			SetMana(800, 1000);

			SetDamage(20, 30);

			SetDamageType(ResistanceType.Physical, 40);
			SetDamageType(ResistanceType.Poison, 60);

			SetResistance(ResistanceType.Physical, 60, 80);
			SetResistance(ResistanceType.Fire, 60, 70);
			SetResistance(ResistanceType.Cold, 60, 70);
			SetResistance(ResistanceType.Poison, 80);
			SetResistance(ResistanceType.Energy, 60, 70);

			SetSkill(SkillName.EvalInt, 77.6, 110.5);
			SetSkill(SkillName.Necromancy, 120.6, 130.5);
			SetSkill(SkillName.SpiritSpeak, 120.1, 150.5);
			SetSkill(SkillName.Magery, 100.1, 120.1);
			SetSkill(SkillName.Poisoning, 80.5);
			SetSkill(SkillName.Meditation, 110.0);
			SetSkill(SkillName.MagicResist, 80.1, 85.0);
			SetSkill(SkillName.Parry, 90.1, 95.1);
			SetSkill(SkillName.Tactics, 100.0);
			SetSkill(SkillName.Wrestling, 120.1, 150.0);
			SetSkill(SkillName.Anatomy, 100.0);

			Fame = 6000;
			Karma = -9500;

			VirtualArmor = 80;
			Tamable = false;

			PackNecroScroll(Utility.RandomMinMax(2, 6));
			PackNecroReg(7, 15);
		}

		public override void GenerateLoot()
		{
			AddLoot(LootPack.Miscellaneous);
			AddLoot(LootPack.HighScrolls, 8);
			AddLoot(LootPack.MedScrolls, 15);
		}

		public override int Meat { get { return 1; } }
		public override Poison PoisonImmune { get { return Poison.Lethal; } }
		public override int TreasureMapLevel { get { return 5; } }
		public override bool CanRummageCorpses { get { return true; } }
		public override bool BardImmune { get { return true; } }
		public override bool Unprovokable { get { return true; } }
		public override bool Uncalmable { get { return true; } }
		public override bool IsNotScaredOfDeath { get { return true; } } //neutika pri malem poctu hp

		public override void OnDamage(int amount, Mobile from, bool willKill, int typ)
		{
			base.OnDamage(amount, from, willKill, typ);

			if (Utility.RandomDouble() < 0.005)
				Ability.FlameSpray(6, 35, this, false);

			if (from != null && Utility.RandomDouble() < 0.07 && this.Hits < (this.HitsMax * 50) / 100)
			{
				Server.Engines.XmlSpawner2.FlareVortex vortex = new Server.Engines.XmlSpawner2.FlareVortex();

				vortex.ItemID = 8726;
				vortex.Hue = 1266;
				vortex.Name = "ice crystal";
				vortex.MoveToWorld(TavaraSewel.GetSpawnPosition(from.Location, from.Map, 10), from.Map);
			}
		}

		public override OppositionGroup OppositionGroup
		{
			get { return OppositionGroup.TerathansAndOphidians; }
		}

		public IceOphidianMatriarch(Serial serial) : base(serial)
		{
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);
			writer.Write((int) 0);
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);
			int version = reader.ReadInt();
		}
	}
}